package carefulbotjava;

import cz.cuni.pogamut.Client.Agent;
import cz.cuni.pogamut.Client.GameMapSettings;
import cz.cuni.pogamut.Client.PathTypes;
import cz.cuni.pogamut.Client.RcvMsgEvent;
import cz.cuni.pogamut.Client.RcvMsgListener;
import cz.cuni.pogamut.MessageObjects.AddWeapon;
import cz.cuni.pogamut.MessageObjects.Ammo;
import cz.cuni.pogamut.MessageObjects.Health;
import cz.cuni.pogamut.MessageObjects.Item;
import cz.cuni.pogamut.MessageObjects.ItemType;
import cz.cuni.pogamut.MessageObjects.MessageType;
import cz.cuni.pogamut.MessageObjects.Mover;
import cz.cuni.pogamut.MessageObjects.NavPoint;
import cz.cuni.pogamut.MessageObjects.Path;
import cz.cuni.pogamut.MessageObjects.Player;
import cz.cuni.pogamut.MessageObjects.PlayerKilled;
import cz.cuni.pogamut.MessageObjects.Triple;
import cz.cuni.pogamut.MessageObjects.Weapon;
import cz.cuni.pogamut.communication.CommunicationState;
import cz.cuni.pogamut.introspection.PogProp;
import cz.cuni.pogamut.exceptions.PogamutException;
import java.util.List;
import java.util.Random;
import java.util.logging.Level;

/**
 *  NOTE: Class with agent must be marked also in manifest.mf, otherwise IDE don't know, which file it should run.
 */
public class Main extends Agent {

    /** Creates a new instance of agent. */
    public Main() {
    }
    PathManager2 pathManager;
    Random rand = new Random(100);

    /** Creates a new instance of agent. */
    public void doLogic() {

        try {
            if (sense_hasAmmo() && sense_incomingProjectile() && sense_shieldNotEquipped()) {
                //log.info("1");
                action_dodgeProjectile();
                if (!action_run_forHealth()) {
                    action_doubleJump();
                }
                if (sense_hasEnemy() && !sense_enemyRanAway()) {
                    if (sense_dying() && sense_canUseShield()) {
                        action_useShield();
                    } else {
                        action_shootEnemy();
                    }
                } else {
                    action_stopShooting();
                }
            } else if (sense_hasAmmo() && sense_hasEnemy() && !sense_enemyRanAway()) {
                //log.info("2");
                if (!action_run_forHealth()) {
                    action_doubleJump();
                }
                if (sense_dying() && sense_canUseShield()) {
                    action_useShield();
                } else {
                    action_shootEnemy();
                }
            } else if (sense_hasAmmo() && sense_seeEnemy()) {
                //log.info("3");
                action_chooseEnemy();
                if (!action_run_forHealth()) {
                    action_doubleJump();
                }
                if (sense_dying() && sense_canUseShield()) {
                    action_useShield();
                } else {
                    action_shootEnemy();
                }
            } else if (sense_hasAmmo() && sense_beingDamaged()) {
                //log.info("4");
                action_quickTurnaround();
            /*} else if (sense_hearSomething()) {
            action_quickTurnaround();*/
            } else if (sense_hasAmmo() && sense_notHealthy()) {
                //log.info("5");
                action_stopShooting();
                action_run_forHealth();
            } else {
                //log.info("6");
                action_stopShooting();
                action_run_roamAround();
            }
        } catch (Exception ex) {
            log.warning("err:" + ex.getClass() + ":" + ex.getMessage() + ":" + ex.getStackTrace()[0]);
        }


    }
    @PogProp
    public long lastTimeShielded;
    @PogProp
    public int changeWpnCooldown;
    @PogProp
    public Player enemy;
    @PogProp
    public Triple roamTargetLoc;
    public static final int RUNACTION_ROAM = 0,  RUNACTION_RUNFORHEALTH = 1;
    @PogProp
    public int lastRunAction;
    @PogProp
    public long lastTimeEnemySeen;
    @PogProp
    public long lastTimeDodge;
    @PogProp
    public int lastHP;
    @PogProp
    public ItemType jumpWpn;

    public void initAfterSpawn() {
        pathManager = new PathManager2(this, gameMap);
        lastTimeShielded = 0;
        lastTimeEnemySeen = 0;
        changeWpnCooldown = 0;
        lastTimeDodge = 0;
        enemy = null;
        roamTargetLoc = null;
        lastRunAction = -1;
        lastHP = memory.getAgentHealth();
        jumpWpn = null;
    }

    public boolean sense_hasAmmo() {
        return memory.hasAnyLoadedWeapon();
    }

    public boolean sense_shieldNotEquipped() {
        return memory.getCurrentWeapon().getWeaponType().compareTo(ItemType.SHIELD_GUN) != 0;
    }

    public boolean sense_inAir() {
        return memory.isFalling();
    }

    public boolean sense_hearSomething() {
        return memory.getHearNoise();
    }

    public boolean sense_incomingProjectile() {
        return memory.isProjectileComming();
    }

    public boolean sense_beingDamaged() {
        int hp = lastHP;
        lastHP = memory.getAgentHealth();
        return hp > lastHP;
    }

    public boolean sense_dying() {
        return memory.getAgentHealth() < 50;
    }

    public boolean sense_notHealthy() {
        return memory.getAgentHealth() < 100;
    }

    public boolean action_runToEnemy() {
        body.doubleJump();
        if (enemy != null) {
            body.runToTarget(enemy);
        }
        return true;
    }

    public boolean action_stopShooting() {
        body.stopShoot();
        return true;
    }

    public boolean action_quickTurnaround() {
        body.jump();
        body.turnHorizontal(179);
        return true;
    }

    public boolean action_shootEnemy() {
        if (enemy == null) {
            return false;
        }
        // choose new weapon
        AddWeapon oldWpn = memory.getCurrentWeapon();
        AddWeapon newWpn = memory.getBetterWeapon(memory.getAgentLocation(), enemy.getLocation());
        double dist = Triple.distanceInSpace(memory.getAgentLocation(), enemy.getLocation());
        if (dist < 100 && oldWpn.getWeaponType().compareTo(ItemType.SHIELD_GUN) == 0) {
            body.shoot(enemy);
            return true;
        }
        if (newWpn != null && oldWpn.getWeaponType().compareTo(newWpn.getWeaponType()) != 0) {
            if (changeWpnCooldown == 0) {
                body.changeWeapon(newWpn);
                if (jumpWpn != null && jumpWpn.compareTo(newWpn.getWeaponType()) != 0 && jumpWpn.compareTo(ItemType.SHIELD_GUN) == 0) {
                    body.doubleJump();
                }
                jumpWpn = newWpn.getWeaponType();
                changeWpnCooldown = 2;
            }
        } else if (oldWpn.getWeaponType().compareTo(ItemType.SHIELD_GUN) != 0) {
            /*if (dist < 10000 && (oldWpn.getWeaponType().compareTo(ItemType.FLAK_CANNON) == 0 || oldWpn.getWeaponType().compareTo(ItemType.ASSAULT_RIFLE) == 0)) {
            body.shootAlternate(enemy);
            } else*/ {
                body.shoot(enemy);
            }
        }
        if (changeWpnCooldown > 0) {
            changeWpnCooldown--;
        }
        return true;
    }

    public boolean action_doubleJump() {
        body.doubleJump();
        return true;
    }

    public boolean action_dodgeProjectile() {
        //body.dodge(new Triple(0, rand.nextInt(2) == 0 ? -1 : 1, 0));
        if (System.currentTimeMillis() - lastTimeDodge > 1000) {
            lastTimeDodge = System.currentTimeMillis();
            body.dodge(new Triple(0, rand.nextInt(2) == 0 ? -1 : 1, 0));
            body.jump();
        }
        return true;
    }

    public boolean action_useShield() {
        action_updateEnemy();
        if (memory.getCurrentWeapon().getWeaponType().compareTo(ItemType.SHIELD_GUN) != 0) {
            body.changeWeapon(memory.getWeapon(ItemType.SHIELD_GUN));
            jumpWpn = ItemType.SHIELD_GUN;
            changeWpnCooldown = 2;
        } else if (enemy != null && Triple.distanceInSpace(memory.getAgentLocation(), enemy.getLocation()) < 120) {
            body.shoot(enemy);
        } else /*if (!memory.isShooting())*/ {
            if (enemy != null) {
                body.shootAlternate(enemy);
            } else {
                body.shootAlternate(Triple.add(memory.getAgentLocation(), Triple.rotationAsVectorUTUnits(memory.getAgentRotation())));
            }
        }
        lastTimeShielded = System.currentTimeMillis();
        return true;
    }

    public boolean sense_canUseShield() {
        if (changeWpnCooldown > 0) {
            changeWpnCooldown--;
            return true;
        }
        if (memory.getCurrentWeapon().getWeaponType().compareTo(ItemType.SHIELD_GUN) == 0) {
            if (memory.isShooting()) {
                if (memory.getAgentAmmo() > 0) {
                    return true;
                }
                body.stopShoot();
                return false;
            }
            return memory.getAgentAmmo() >= 50;
        }
        return System.currentTimeMillis() - lastTimeShielded > 6000;
    }

    public boolean sense_seeEnemy() {
        if (memory.getSeePlayers().size() != 0) {
            lastTimeEnemySeen = System.currentTimeMillis();
            return true;
        }
        return false;
    }

    public boolean sense_hasEnemy() {
        action_updateEnemy();
        return enemy != null;
    }

    public boolean sense_enemyRanAway() {
        if (enemy == null // enemy not visible for more then 3 seconds
                || (memory.getSeePlayer(enemy.UnrealID) == null && System.currentTimeMillis() - lastTimeEnemySeen > 3000) ||
                // enemy not visible and another enemy is visible -> switch targets
                (memory.getSeePlayer(enemy.UnrealID) == null && memory.getSeePlayers().size() > 0)) {
            enemy = null;
            return true;
        }
        return false;
    }

    public boolean action_chooseEnemy() {
        List<Player> players = memory.getSeePlayers();
        enemy = null;
        for (Player p : players) {
            if (enemy == null || Triple.distanceInSpace(memory.getAgentLocation(), p.getLocation()) < Triple.distanceInSpace(memory.getAgentLocation(), enemy.getLocation())) {
                enemy = p;
            }
        }
        return enemy != null;
    }

    public boolean action_updateEnemy() {
        if (enemy != null) {
            Player en = memory.getSeePlayer(enemy.UnrealID);
            if (en != null) {
                enemy = en;
            }
        }
        return true;
    }

    public boolean action_run_forHealth() {
        action_updateEnemy();
        if (lastRunAction != RUNACTION_RUNFORHEALTH) {
            lastRunAction = RUNACTION_RUNFORHEALTH;
            roamTargetLoc = null;
        }
        if (roamTargetLoc != null && Triple.distanceInSpace(memory.getAgentLocation(), roamTargetLoc) < 50.0) {
            roamTargetLoc = null;
        }
        if (roamTargetLoc == null) {
            Triple tmpLoc = null;
            List<Health> items = memory.getKnownHealths();
            for (Health i : items) {
                double dist = Triple.distanceInSpace(memory.getAgentLocation(), i.location);
                if (dist > 100 && (i.navPoint == null ||
                        (memory.getSeeNavPoint(i.navPoint.UnrealID) == null && dist > 500) || memory.getSeeHealth(i.UnrealID) != null) && (i.boostable || memory.getAgentHealth() < 100)) {
                    tmpLoc = i.location;
                    // I want only healths that are far from the enemy, if he has a more melee wpn
                    if (enemy != null &&
                            ((enemy.getPlayerWeapon().compareTo("XWeapons.FlakCannon") == 0 && !memory.hasWeaponOfType(ItemType.FLAK_CANNON)) || sense_dying())) {
                        Triple toEnemy = Triple.subtract(enemy.getLocation(), memory.getAgentLocation());
                        Triple toHealth = Triple.subtract(i.location, memory.getAgentLocation());
                        if (Triple.multiScalar(toEnemy, toHealth) <= 0) {
                            roamTargetLoc = i.location;
                        //log.info("accept");
                        } else {
                        //log.info("refuse");
                        }
                    } else {
                        roamTargetLoc = i.location;
                    }
                }
            }
            if (roamTargetLoc == null) {
                roamTargetLoc = tmpLoc;
            }
        }

        if (roamTargetLoc == null) {
            return false;
        }
        if (!followWaypoints(roamTargetLoc, enemy == null ? null : enemy.getLocation())) {
            roamTargetLoc = null;
            return false;
        }
        return true;

    }

    public boolean action_run_roamAround() {
        if (lastRunAction != RUNACTION_ROAM) {
            lastRunAction = RUNACTION_ROAM;
            roamTargetLoc = null;
        }
        if (roamTargetLoc != null && Triple.distanceInSpace(memory.getAgentLocation(), roamTargetLoc) < 50.0) {
            roamTargetLoc = null;
        }
        if (roamTargetLoc == null) {
            List<Weapon> items = memory.getKnownWeapons();
            for (Weapon i : items) {
                if (!memory.hasWeaponOfType(i.getWeaponType()) && roam_isItemSuitable(i)) {
                    roamTargetLoc = i.location;
                }
            }
            if (roamTargetLoc == null) {
                List<NavPoint> pts = memory.getKnownNavPoints();
                roamTargetLoc = pts.get(Math.abs(rand.nextInt()) % pts.size()).getLocation();
            }
        }
        if (roamTargetLoc == null) {
            return false;
        }
        if (!followWaypoints(roamTargetLoc, null)) {
            roamTargetLoc = null;
            return false;
        }
        return true;
    }

    private boolean roam_isItemSuitable(Item item) {
        double distToItem = Triple.distanceInSpace(memory.getAgentLocation(), item.location);
        if (distToItem < 100.0) {
            return false;
        }

        if (roamTargetLoc == null) {
            return true;
        }

        if (distToItem > Triple.distanceInSpace(memory.getAgentLocation(), roamTargetLoc)) {
            return false;
        }

        return true;
    }

    class Listener implements RcvMsgListener {

        @Override
        public void receiveMessage(RcvMsgEvent e) {
            if (e.getCommunicationState() != CommunicationState.BOT_RUNNING) {
                return;
            }

            switch (e.getMessage().type) {
                case PLAYER_KILLED:
                    PlayerKilled msg = (PlayerKilled) e.getMessage();
                    if (msg.killerID == memory.getAgentID() && enemy != null && msg.playerID == enemy.getID()) {
                        enemy = null;
                    }
                    break;
                case SPAWN:
                    initAfterSpawn();
                    break;
                case PATH:
                    pathManager.newGBPathReceived((Path) e.getMessage());
                    break;
            }
        }
    }

// if lookat is null, then the bot will look left and right while running
    public boolean followWaypoints(Triple location, Triple lookat) {
        // if bot is close to the item there is a chance that he will not receive path!!! so he runs towards the location
        /*if ((Triple.distanceInSpace(this.memory.getAgentLocation(), location) < 500)) {
        body.runToLocation(location); // experimental!!!
        return true;
        }*/
        if (!pathManager.checkPath(PathTypes.LOCATION, location)) {
            pathManager.preparePath(PathTypes.LOCATION, location, false);

            return true;
        } else {
            return runAlongPath2(lookat);
        }

    }

    public boolean runAlongPath2(Triple lookat) {
        if (pathManager.pathToRunAlong == null) {
            platformLog.warning("procedure called when the variables were not properly initialized!");
            return false;
        }
// end of the path
        if (pathManager.getCurrentNavPointOfPath() == null) {
            platformLog.fine("runAlongPath - PATH END : " + pathManager.pathToRunAlong);
            return false;
        }

        NavPoint nav1 = pathManager.getCurrentNavPointOfPath();

        // bot is to close to the next navPoint, switch to another
        // don't switch to another when you are at the end ... or more precisely switch to it at different distance from the navigation point
        if ((pathManager.getNextNavPointOfPath() == null) &&
                (pathManager.nextNavPointIndex < pathManager.pathToRunAlong.size()) &&
                (Triple.distanceInSpace(this.memory.getAgentLocation(), nav1.location) < GameMapSettings.lastNavigationPointOfPathPrecision)) {
            platformLog.info("Last nav point of the path approached.");
            pathManager.walking = 0;
            ++pathManager.nextNavPointIndex;
            return true;
        } else {
            if ((Triple.distanceInSpace(this.memory.getAgentLocation(), nav1.location) < GameMapSettings.switchingDistance)) {
                platformLog.info("Switching to another navigation point. Last point: " + nav1.UnrealID);
                pathManager.walking = 0;
                ++pathManager.nextNavPointIndex;
                return true;
            }

        }
        // navpoint is null - don't know why, but even such a things happen
        if (nav1 == null || nav1.UnrealID == null) {
            ++pathManager.nextNavPointIndex;
            return true;
        }
// bot is in the moving along the center of the lift center - switch to another nav point (lift exit)
        if ((nav1.UnrealID.indexOf("LiftCenter") != -1) &&
                (Triple.distanceInPlane(this.memory.getAgentLocation(), nav1.location) < GameMapSettings.switchingDistance)) {
            platformLog.info("Switching to another navigation point. Last point: " + nav1.UnrealID);
            pathManager.walking = 0;
            ++pathManager.nextNavPointIndex;
            return true;
        }
// bot is still on its way, call moveAlong if he still has more than 1 navpoint on the remaining path
// use runTo if there is only one
        if (pathManager.getNextNavPointOfPath() != null) {
            NavPoint nav2 = pathManager.getNextNavPointOfPath();
            // TODO: now it is only for the way up, not tested for movers which goes down as I don't know suitable map
            // catch possible null pointer exception
            try {
                // agent is going to enter the lift (LiftCenter) and he is going through it (LiftExit) and 
                // agent is not on the top of the lift
                if ((nav1.UnrealID.indexOf("LiftCenter") != -1) &&
                        (nav2.UnrealID.indexOf("LiftExit") != -1) &&
                        ((this.memory.getAgentLocation().z - nav1.location.z) < 50)) {
                    // if agent sees mover - go on, else fail the run along - no possibility to move on the lift without mover
                    if (!this.memory.getSeeAnyMover()) {
                        return false;
                    } else {
                        Mover mov = memory.getSeeMover();
                        if ((mov.location.z - this.memory.getAgentLocation().z) > GameMapSettings.levelForEnteringLift) {// mover is up - wait for it
                            platformLog.fine("Waiting for MOVER to come DOWN");
                            ++pathManager.walking;
                            if (pathManager.walking > GameMapSettings.maxWalkingAttempts) {
                                pathManager.walking = 0;
                                return false;
                            }

                            return true;
                        } else {                        // enter the mover
                            platformLog.fine("ENTERING the Mover");
                            this.body.runToNavPoint(nav1);
                            pathManager.isUpOnTheLift = true;
                            return stuckCheck2();
                        }

                    }
                } else {
                    // let's go from the mover - so wait until agent got up and leave
                    if ((pathManager.isUpOnTheLift) && (nav1.UnrealID.indexOf("LiftExit") != 1)) {
                        if (!this.memory.getSeeAnyMover()) {
                            return false;
                        } else {
                            // agent's z (height) coordinate is about the same level with lift exit - leave mover
                            if ((nav1.location.z - this.memory.getAgentLocation().z) < GameMapSettings.levelForLeavingLift) {// mover is up - leave
                                platformLog.fine("LEAVING MOVER!");
                                pathManager.isUpOnTheLift = false;
                                this.body.runToNavPoint(nav1);
                                return stuckCheck2();
                            } else {
                                // still going up on the mover - turn to the nav point at the top and wait 
                                body.turnToLocation(nav1.location);
                                // special stuck check - as agent is on the lift, he will be moving everytime, so it checks
                                // only the lenght of his stay 
                                ++pathManager.walking;
                                if (pathManager.walking > GameMapSettings.maxWalkingAttempts) {
                                    pathManager.walking = 0;
                                    return false;
                                }

                                platformLog.fine("GOING UP " + (nav1.location.z - this.memory.getAgentLocation().z));
                                return true;
                            }

                        }
                    } else {
                        // normal movement along 2 points
                        //this.body.moveAlongNavPoints(1, nav1, nav2);
                        moveToNavPoint(nav1, lookat);
                        return stuckCheck2();
                    }

                }
            } catch (NullPointerException e) {
                platformLog.warning("Null pointer exception in run along path " + e.getMessage());
            }

        } else {
            if (pathManager.nextNavPointIndex < pathManager.pathToRunAlong.size()) {
                //this.body.runToNavPoint(nav1);
                moveToNavPoint(nav1, lookat);
                return stuckCheck2();
            }

        }
        // fail - nowhere to go
        return false;
    }
    int lookState = 0;

    public void moveToNavPoint(NavPoint nav1, Triple lookat) {
        if (lookat == null) {
            Triple dir = Triple.subtract(nav1.location, memory.getAgentLocation());
            dir.z = 0;
            dir.normalize();
            Triple normal = new Triple(-dir.y, dir.x, 0);
            if (lookState < 3) {
                normal = Triple.multiplyByNumber(normal, 5.0);
            } else {
                normal = Triple.multiplyByNumber(normal, -5.0);
            }

            lookState++;
            if (lookState >= 6) {
                lookState = 0;
            }

            dir = Triple.multiplyByNumber(dir, 10.0);
            body.strafeToLocation(nav1.location, Triple.add(Triple.add(memory.getAgentLocation(), dir), normal));
        //body.runToLocation(nav1.location);
        } else {
            body.strafeToLocation(nav1.location, lookat);
        }

    }

    public boolean stuckCheck2() {
        // check whether agent is stucked - yet in the rough testing
        boolean stucked = gameMap.antiStuckCheck(pathManager.getCurrentNavPointOfPath().location);
        boolean attempts = false;
        ++pathManager.walking;
        // it has 15 attempts to reach the navPoint, if it fails, return false
        if (pathManager.walking > GameMapSettings.maxWalkingAttempts) {
            attempts = true;
        }

        if (attempts && stucked) {
            attempts = false;
            platformLog.fine("REPLAN because bot reached max ATTEMPTS and was STUCKED");
            return false;
        }

        return true;
    }

    protected void prePrepareAgent() throws PogamutException {
    /* Prepares agent logic to run - like initializing neural networks etc.
    not for establishing communication! */
    }

    protected void postPrepareAgent() throws PogamutException {
        /* Prepare logic according to information from gathered from startCommunication
        like choosing plan/parameters according to game type. */
        body.addRcvMsgListener(new Listener());
        body.initializer.setBotSkillLevel(3);
    }

    protected void shutdownAgent() throws PogamutException {
    // Clean up after the end of simulation of agent

    }

    public static void main(String[] args) {
    /*
    DON'T DELETE THIS METHOD, IF YOU DELETE IT NETBEANS WON'T LET YOU RUN THIS 
    BOT. HOWEVER THIS METHOD IS NEVER EXECUTED, THE BOT IS LAUNCHED INSIDE THE 
    NETBEANS BY A CUSTOM ANT TASK (see build.xml).
     */
    }
}
